#!/usr/bin/env python3
"""Portable Listener v2.5"""
import sys
sys.path.insert(0, '../python/Lib/site-packages')

import requests
import subprocess
import time
import os
from datetime import datetime

# Config
try:
    from config import *
except:
    API_URL = "https://wintask.92-5-72-169.sslip.io"
    TELEGRAM_BOT = ""
    TELEGRAM_CHAT = ""
    CHECK_INTERVAL = 10

LOG_FILE = "listener.log"

def log(msg):
    ts = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
    line = f"[{ts}] {msg}"
    print(line)
    with open(LOG_FILE, "a", encoding="utf-8") as f:
        f.write(line + "\n")

def telegram(text):
    if TELEGRAM_BOT and TELEGRAM_CHAT:
        try:
            requests.post(f"https://api.telegram.org/bot{TELEGRAM_BOT}/sendMessage",
                          json={"chat_id": TELEGRAM_CHAT, "text": text[:4000]}, timeout=10)
        except: pass

def get_task():
    try:
        r = requests.get(f"{API_URL}/task", timeout=10)
        task = r.json().get("task")
        if task and task.get("status") == "pending":
            return task
    except Exception as e:
        log(f"Error: {e}")
    return None

def send_result(result, task_id=""):
    try:
        requests.post(f"{API_URL}/result", json={"result": result, "task_id": task_id}, timeout=10)
    except: pass

def execute(task_text):
    upper = task_text.upper().strip()
    
    if upper == "PING":
        return f"PONG! {datetime.now()}"
    if upper == "STATUS":
        return f"Portable Listener v2.5\nPID: {os.getpid()}"
    if upper.startswith("PS:"):
        try:
            r = subprocess.run(["powershell", "-Command", task_text[3:]], capture_output=True, text=True, timeout=60)
            return r.stdout or r.stderr or "No output"
        except Exception as e:
            return f"Error: {e}"
    if upper.startswith("PY:"):
        try:
            r = subprocess.run(["python", "-c", task_text[3:]], capture_output=True, text=True, timeout=60)
            return r.stdout or r.stderr or "No output"
        except Exception as e:
            return f"Error: {e}"
    
    # Default: Claude Code
    try:
        claude = os.path.expandvars(r"%APPDATA%\npm\claude.cmd")
        r = subprocess.run([claude, "-p", "--dangerously-skip-permissions", task_text],
                          capture_output=True, text=True, timeout=300)
        return r.stdout or r.stderr or "No output"
    except Exception as e:
        return f"Claude Error: {e}"

def main():
    log("=" * 40)
    log("PORTABLE LISTENER v2.5 STARTED")
    log(f"API: {API_URL}")
    log("=" * 40)
    telegram("🟢 Portable Listener started!")
    
    while True:
        try:
            task = get_task()
            if task:
                log(f"Task: {task.get('task', '')[:50]}...")
                result = execute(task.get("task", ""))
                send_result(result, task.get("id", ""))
                log("Done!")
            time.sleep(CHECK_INTERVAL)
        except KeyboardInterrupt:
            break
        except Exception as e:
            log(f"Error: {e}")
            time.sleep(CHECK_INTERVAL)

if __name__ == "__main__":
    main()
