#!/usr/bin/env python3
"""
Windows Listener v2.8 - Render Proxy
====================================
Bypasses Windows firewall via Render
"""

import requests
import subprocess
import time
import os
from datetime import datetime

# === CONFIG ===
API_URL = "https://wintask-proxy.onrender.com"
POLL_INTERVAL = 10
CLAUDE_CMD = "claude"

def log(msg):
    timestamp = datetime.now().strftime("%H:%M:%S")
    print(f"[{timestamp}] {msg}")

def execute_claude(prompt, timeout=120):
    try:
        cmd = [CLAUDE_CMD, "-p", "--dangerously-skip-permissions", prompt]
        result = subprocess.run(cmd, capture_output=True, text=True, timeout=timeout, shell=True)
        return {
            "success": result.returncode == 0,
            "output": (result.stdout + result.stderr)[:4000],
            "exit_code": result.returncode
        }
    except subprocess.TimeoutExpired:
        return {"success": False, "output": f"Timeout after {timeout}s", "exit_code": -1}
    except Exception as e:
        return {"success": False, "output": str(e), "exit_code": -1}

def execute_powershell(cmd):
    try:
        result = subprocess.run(["powershell", "-Command", cmd], capture_output=True, text=True, timeout=60)
        return {"success": result.returncode == 0, "output": (result.stdout + result.stderr)[:4000], "exit_code": result.returncode}
    except Exception as e:
        return {"success": False, "output": str(e), "exit_code": -1}

def execute_python(code):
    try:
        result = subprocess.run(["python", "-c", code], capture_output=True, text=True, timeout=60)
        return {"success": result.returncode == 0, "output": (result.stdout + result.stderr)[:4000], "exit_code": result.returncode}
    except Exception as e:
        return {"success": False, "output": str(e), "exit_code": -1}

def process_task(task):
    task_id = task.get("id")
    message = task.get("task", "")
    
    log(f"📥 Task {task_id}: {message[:50]}...")
    
    msg_upper = message.upper().strip()
    
    if msg_upper == "PING":
        return {"success": True, "output": "PONG! Listener v2.8 (Render) active", "exit_code": 0}
    
    if msg_upper == "STATUS":
        import platform
        info = f"OS: {platform.system()} {platform.release()}\nPython: {platform.python_version()}\nHost: {platform.node()}\nProxy: Render"
        return {"success": True, "output": info, "exit_code": 0}
    
    if msg_upper in ["STOP", "EXIT", "QUIT"]:
        return {"success": True, "output": "Stopping...", "exit_code": 0, "stop": True}
    
    if message.upper().startswith("PS:"):
        return execute_powershell(message[3:].strip())
    
    if message.upper().startswith("PY:"):
        return execute_python(message[3:].strip())
    
    return execute_claude(message)

def main():
    log("=" * 45)
    log("🖥️ LISTENER v2.8 (Render Proxy)")
    log(f"API: {API_URL}")
    log("=" * 45)
    
    errors = 0
    
    while True:
        try:
            r = requests.get(f"{API_URL}/status", timeout=30)
            data = r.json()
            
            task = data.get("task")
            if task and task.get("status") == "pending":
                result = process_task(task)
                requests.post(f"{API_URL}/result/{task['id']}", json=result, timeout=30)
                log(f"✅ Task {task['id']} done")
                
                if result.get("stop"):
                    break
            
            errors = 0
            
        except Exception as e:
            errors += 1
            log(f"⚠️ Error ({errors}): {str(e)[:50]}")
            if errors >= 10:
                log("❌ Too many errors, waiting 60s...")
                time.sleep(60)
                errors = 0
        
        time.sleep(POLL_INTERVAL)

if __name__ == "__main__":
    main()
